﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var question = {

    // GENERAL SETTINGS
    opts: {
        debug_mode: false,
        isPreloaded: false,
        containers: {
            questionnaire: { id: 'divQuestions' }
        },
        horizontalTbl: { css_class: 'tbl-horizontal' },
        customLogic: [
                { mid: 3000, src: 'js/questions.mid3000.js' },
                { mid: 4000, src: 'js/questions.mid4000.js' },
                { mid: 4001, src: 'js/questions.mid4001.js' },
                { mid: 4002, src: 'js/questions.mid4002.js' },
                { mid: 4004, src: 'js/questions.mid4004.js' },
                { mid: 4008, src: 'js/questions.mid4008.js' },
                { mid: 4014, src: 'js/questions.mid4014.js' },
                { mid: 4026, src: 'js/questions.mid4026.js' },
                { mid: 4040, src: 'js/questions.mid4040.js' },
                { mid: 4044, src: 'js/questions.mid4044.js' },
                { mid: 4048, src: 'js/questions.mid4048.js' },
                { mid: 4050, src: 'js/questions.mid4050.js' },
                { mid: 4052, src: 'js/questions.mid4052.js' },
                { mid: 4062, src: 'js/questions.mid4062.js' },
                { mid: 4068, src: 'js/questions.mid4068.js' },
                { mid: 4072, src: 'js/questions.mid4072.js' },
                { mid: 4074, src: 'js/questions.mid4074.js' },
                { mid: 4078, src: 'js/questions.mid4078.js' },
                { mid: 4082, src: 'js/questions.mid4082.js' }
        ],
        currModule: { id: 'htxtMID' }
    },

    // fn RESPONSES
    clearQuestionResponses: function (divQestion) {
        var _me = this;

        //clear previous validation error messages
        //_me.clearPrevErrors(divQestion);

        // clear radio and checkboxes
        $('input[type="radio"], input[type="checkbox"]', $(divQestion)).each(function () {
            this.checked = false;
        });

        //clear select
        $('option', $(divQestion)).each(function () {
            $(this).attr('selected', false);
            $(this).trigger('change');
        });

        // clear textboxes and textarea
        $('input[type="text"], input[type="hidden"], textarea', $(divQestion)).each(function () {
            this.value = '';
        });
    },

    validateQuestionnaire: function () {
        var _me = this,
            _qDiv = $('div.question-container[reqd-val="1"]').not('[skipped]').not('.disabled'),
            _qCount = _qDiv.length,
            _rCount = 0;

        //clear hidden questions with error warnings
        $('div.question-container[reqd-val="1"][skipped], div.question-container.disabled[reqd-val="1"]').each(function (i, d) {
            //clear previous validation error messages
            _me.clearPrevErrors(d);
        });

        //if the instrument is editable skip validation
        if ($('[editable="0"]').length == 0) {
            return true;
        }

        $.each(_qDiv, function (i, d) {
            var c1 = $('input[type="radio"]:checked, input[type="checkbox"]:checked', $(d)).length,
                c2 = $('select', $(d)).filter(function (i, ele) {
                    return ele.selectedIndex > 0;
                }).length,
                c3 = $('input[type="text"], textarea', $(d)).filter(function (i, ele) {
                    return ele.value.length > 0;
                }).length;

            //clear previous validation error messages
            _me.clearPrevErrors(d);

            if ((c1 + c2 + c3) > 0) {
                _rCount += 1;
            }
            else {
                //show error message
                _me.showValidationErrMessage(d);
            }

        });

        if (_qCount > 0) {
            if (_rCount >= _qCount) {
                return true;
            }
            else {
                //alert('Please review highlighted question, make necessary corrections and submit your responses again.');
                alert('Please select a response for the highlighted question(s) before submitting.');
                return false;
            }
        }

        return false;
    },

    showValidationErrMessage: function (div) {
        var _me = this,
            _msg = '<h5 class="validation-err" style="color: red;"><span class="glyphicon glyphicon-warning-sign"></span>&nbsp;A response is required for this question.</h5>';

        $(div).addClass('bg-warning');
        $('h4', $(div)).prepend(_msg);
    },

    clearPrevErrors: function (div) {
        var _me = this;

        //clear validation error warnings
        $('h5.validation-err', $(div)).remove();
        $(div).removeClass('bg-warning');
    },

    clearAbove: function (ele) {
        var _me = this,
            _dQ = _me.getQuestionDivByRID(ele.id),
            skipPattern = null;

        //check if the element has the 'clearabove' attribute
        if (ele.getAttribute('clearabove') != null) {
            if (ele.checked) {
                //clear question responses
                if (_dQ) {
                    _me.clearQuestionResponses(_dQ);
                    ele.checked = true;

                    $('[rid]', _dQ).each(function (a, b) {
                        _me.checkSkipPatterns(b);
                    });
                }
            }
        }
        else {
            // ----- check for the related controls status -----
            if (ele.tagName.toLowerCase() == 'input') {
                var _type = $(ele).attr('type').toLowerCase();
                switch (_type) {
                    case 'radio':
                        if (ele.checked) {
                            if (_dQ) {
                                $('[clearabove]', $(_dQ)).attr('checked', false);
                            }
                        }
                        break;

                    case 'checkbox':
                        if (ele.checked) {
                            if (_dQ) {
                                $('[clearabove]', $(_dQ)).attr('checked', false);
                            }
                        }
                        break;

                    case 'text':
                        if ($(ele).val().length > 0) {
                            if (_dQ) {
                                $('[clearabove]', $(_dQ)).attr('checked', false);
                            }
                        }
                        break;
                }
            }
            else if (ele.tagName == 'select') {
                //do something
            }
            else if (ele.tagName == 'textarea') {
                //do something
            }
        }

    },

    // fn SKIP PATTERNS
    checkSkipPatterns: function (e) {
        var _me = this,
            _ele = null,
            _useCascadeHide = true,
            skipPattern = null;
        
        //check if e (parameter for event) is present
        if (typeof (e) === "undefined") {
            skipPattern = _me.opts.skipPatterns; //all skip patterns
        }
        else {
            //select the corresponding pattern
            if (typeof (e.target) === "undefined") {
                skipPattern = $(_me.opts.skipPatterns).filter(function (index) { return $(this).attr('rid') == $(e).attr('rid') });
                _useCascadeHide = false;
            }
            else {
                _ele = e.target;
                skipPattern = $(_me.opts.skipPatterns).filter(function (index) { return $(this).attr('rid') == $(_ele).attr('rid') });
            }
        }
               
        if (typeof (skipPattern) === "object") {
            //iterate the skip rules
            $.each(skipPattern, function (a, b) {
                //get the skip trigger control
                if (!isNaN(b.rid)) {
                    if (_useCascadeHide) {
                        _me.cascadeHide(b);
                    }
                    _me.checkSimpleRIDSkip(b);
                }
                else {
                    return;
                }
            });
        }
    },

    cascadeHide: function (d,h) {
        var _me = this,
            subSkipPattern = null,
            r = $('input[type="checkbox"], input[type="radio"]').filter(function (i, ele) {
                return $(this).attr('id') == "rid_" + d.rid;
            })[0];

        if (typeof (r) != "undefined") {
            if (r.type == "checkbox") {
                if (typeof (h) == "undefined") {
                    if (r.checked == false) {
                        _me.nextSkipPattern(d.checked.show, false);
                    }
                }
                else {
                    _me.nextSkipPattern(d.checked.show, true);
                }
            }

            if (r.type == "radio") {
                if (typeof (h) == "undefined") {
                    _me.nextSkipPattern(d.checked.hide, false);
                }
                else {
                    _me.nextSkipPattern(d.checked.show, true);
                }
            }
        }
    },

    nextSkipPattern: function (parentSkipPattern, hideQ) {
        var _me = this;

        if (typeof (parentSkipPattern) !== "undefined") {
            parentSkipPattern.forEach(function (qID) {
                $.each($('#' + qID + ' [id^="rid_"]:checked'), function (i, j) {
                    //only the responses checked could have shown additional questions
                    //get the skip pattern, if any, of them...
                    subSkipPattern = $(_me.opts.skipPatterns).filter(function (index) { return $(this).attr('rid') == $(j).attr('rid') });

                    if (typeof (subSkipPattern) === "object") {
                        //iterate the skip rules
                        $.each(subSkipPattern, function (a, b) {
                            //get the skip trigger control
                            if (!isNaN(b.rid)) {
                                _me.cascadeHide(b, 1);
                            }
                            else {
                                return;
                            }
                        });
                    }
                });

                if (hideQ) {
                    //hide this question...
                    _me.hideQuestion(qID);
                }
            });
        }
    },

    hideQuestion: function (qID) {
        var _me = this,
            _divQ = $('div[id$="' + qID + '"]');

        //set 'skipped' attribute
        $(_divQ).attr('skipped', true);
        $('[name^="grp"]', $(_divQ)).each(function () {
            var _name = $(this).attr('name');
            if (_name.indexOf("skip_") < 0) {
                $(this).attr("name", "skip_" + _name);
            }
        });

        //reset question's responses
        _me.clearQuestionResponses(_divQ);

        //hide question
        _divQ.hide();
    },

    checkSimpleRIDSkip: function (b) {
        var _me = this;
        var r = $('input[type="checkbox"], input[type="radio"]').filter(function (i, ele) {
            return $(this).attr('id') == "rid_" + b.rid;
        })[0];
        if (typeof (r) !== "undefined") {
            if (r.checked) {
                //show questions
                if (typeof (b.checked.show) !== "undefined") {
                    b.checked.show.forEach(function (qID) {
                        var _divQ = $('div[id$="' + qID + '"]');

                        if ($(_divQ).is(':hidden')) {
                            //remove 'skipped' attribute
                            $(_divQ).removeAttr('skipped');
                            $('[name^="skip_"]', $(_divQ)).each(function () {
                                var _name = $(this).attr('name');
                                if (_name.indexOf("skip_") >= 0) {
                                    $(this).attr("name", _name.replace(/skip_/gi, ''));
                                }
                            });

                            //reset question's responses
                            if (!_me.opts.isPreloaded) {
                                _me.clearQuestionResponses(_divQ);
                            }

                            //show question
                            _divQ.show();
                        }
                    });
                }

                //hide questions
                if (typeof (b.checked.hide) !== "undefined") {
                    b.checked.hide.forEach(function (qID) {
                        var _divQ = $('div[id$="' + qID + '"]');

                        //set 'skipped' attribute
                        $(_divQ).attr('skipped', true);
                        $('[name^="grp"]', $(_divQ)).each(function () {
                            var _name = $(this).attr('name');
                            if (_name.indexOf("skip_") < 0) {
                                $(this).attr("name", "skip_" + _name);
                            }
                        });

                        _me.clearQuestionResponses(_divQ);

                        //hide question
                        _divQ.hide();
                    });
                }

            } else {
                //hide questions
                if (typeof (b.checked.show) !== "undefined") {
                    b.checked.show.forEach(function (qID) {
                        var _divQ = $('div[id$="' + qID + '"]');
                        
                        //set 'skipped' attribute
                        $(_divQ).attr('skipped', true);
                        $('[name^="grp"]', $(_divQ)).each(function () {
                            var _name = $(this).attr('name');
                            if (_name.indexOf("skip_") < 0) {
                                $(this).attr("name", "skip_" + _name);
                            }
                        });

                        _me.clearQuestionResponses(_divQ);
                        
                        //hide question
                        _divQ.hide();
                    });
                }

                //show questions
                if (typeof (b.checked.hide) !== "undefined") {
                    b.checked.hide.forEach(function (qID) {
                        var _divQ = $('div[id$="' + qID + '"]');
                        
                        if ($(_divQ).is(':hidden')) {
                            //remove 'skipped' attribute
                            $(_divQ).removeAttr('skipped');
                            $('[name^="skip_"]', $(_divQ)).each(function () {
                                var _name = $(this).attr('name');
                                if (_name.indexOf("skip_") >= 0) {
                                    $(this).attr("name", _name.replace(/skip_/gi, ''));
                                }
                            });


                            //reset question's responses
                            if (!_me.opts.isPreloaded) {
                                _me.clearQuestionResponses(_divQ);
                            }

                            //show question
                            _divQ.show();
                        }
                    });
                }

            }
        }
    },

    //format horizontal tables
    formatHorizontalTbl: function () {
        var _me = this;
        $('.' + _me.opts.horizontalTbl.css_class).each(function () {
            if ($('input[type="checkbox"], input[type="radio"]', $(this)).length > 0) {
                $('td', $(this)).css({
                    border: '1px solid #e1e1e1'
                });
            }
        });
    },

    //apply custom logic file for modules
    applyCustomLogic: function (_logic) {
        var _me = this;
        var _src = $('<script type="text/javascript" id="customLogic" />').attr('src', _logic);

        $('#customLogic').remove();

        $(_src).appendTo('body');
    },

    setPatientResponses: function (respData) {
        var _me = this,
        _resp = $('[rid]');

        //if (typeof (respData) === "object") {
        //    if (respData !== "undefined") {
        //        if (respData.length > 0) {
        //            _me.opts.isPreloaded = true;
        //        }
        //    }
        //}
        $.each(respData, function (i, o) {
            $.each(_resp, function (a, r) {
                if (o.RID == r.id.replace(/\D/gi, '')) {
                    switch (r.tagName.toLowerCase()) {
                        case 'input':
                            var _type = $(r).attr('type');
                            switch (_type.toLowerCase()) {
                                case 'text':
                                    $(r).val(o.RESPONSE_VALUE);
                                    break;

                                case 'radio':
                                    $(r).attr('checked', true);
                                    $(r).click(); /*this will trigger any custom logic*/
                                    break;

                                case 'checkbox':
                                    //$(r).attr('checked', true);
                                    //this will trigger any custom logic
                                    if (!$(r).is(':checked')) {
                                        $(r).click();
                                    }
                                    break;
                            }
                            break;

                        case 'select':
                            $('option', $(r)).each(function () {
                                var optRawVal = $(this).attr('value'),
                                    optVal = optRawVal.split('|')[0];
                                if (optVal == ('' + o.RESPONSE_VALUE)) {
                                    $(this).attr('selected', true);
                                    $(this).trigger('change');
                                }
                            });
                            break;

                        case 'textarea':
                            $(r).val(o.RESPONSE_VALUE);
                            break;
                    }
                }
            });
        });
    },
	
	// Sliders
    applySliders: function () {
        var me = this;
        $('select.combo-slider').each(function () {
            var m_slider = null;
            var mSelect = this,
                mSlider = $('[sliderfor="' + $(this).attr('name') + '"]')[0],
                mValue = $(mSelect).val() || 0;

            var _max = parseInt($('option', mSelect).length) > 1 ? parseInt($('option', mSelect).length) - 2 : 1;

            //check if the jQueryUI slider widget exists
            if (typeof ($(mSlider).slider) !== "undefined") {
                m_slider = $(mSlider).slider({
                    min: 0,
                    max: _max,
                    range: "min",
                    value: mValue,
                    slide: function (event, ui) {
                        mSelect.selectedIndex = ui.value + 1;
                    }
                });


                $(mSelect).on('change', function () {
                    var mVal = this.selectedIndex;
                    if (mVal > 0) {
                        mVal = mVal - 1;
                    }

                    if (mVal != null) {
                        m_slider.slider("value", mVal);
                    }
                });

                $('.slide-container').show();
            }
        });
    },

    // Datepicker
    applyDatepicker: function () {
        var _me = this;
        $(".datepicker").datepicker();
    },

    // BINDINGS ---------------------------
    bindSkipPatterns: function () {
        var _me = this;
        if (typeof (_me.opts.skipPatterns) === "object") {
            //iterate the skip rules
            $.each(_me.opts.skipPatterns, function (a, b) {
                if (!isNaN(b.rid)) {

                    //get the question div of the response with skip
                    var _div = _me.getQuestionDivByRID('rid_' + b.rid);

                    //bind the skip check to the responses
                    if (_div) {
                        $('input[type="radio"], input[type="checkbox"]', _div).each(function () {
                            var b = $(this).bind('click', function (e) {
                                _me.checkSkipPatterns(e);
                            });

                            if (_me.opts.debug_mode) {
                                $(b).parent().css({ color: 'red' });
                            }
                        });
                    }
                }
            });
        }
        return;
    },

    bindClearAbove: function () {
        var _me = this;

        $('[clearabove]').each(function () {
            var rid = this.id,
                _dQuestion = _me.getQuestionDivByRID(rid);
            
            if (typeof (_dQuestion) !== "undefined") {

                //bind radio and checkboxes
                $('input[type="radio"], input[type="checkbox"]', $(_dQuestion)).bind('click', function (e) {
                    _me.clearAbove(this);
                });

                //bind dropdown
                $('select', $(_dQuestion)).bind('change', function (e) {
                    _me.clearAbove(this);
                });

                //bind textbox and textarea
                $('input[type="text"]', $(_dQuestion)).bind('keyup', function (e) {
                    _me.clearAbove(this);
                });
            }
        });
    },

    //apply masks to textboxes
    applyMask: function () {
        var _me = this,
            setCursorOnStart = function (obj, event) {
                if (event.type == "click") {
                    if ($(obj).hasClass('txtGotFocus')) {
                        return false;
                    } else {
                        $(obj).addClass('txtGotFocus')
                    }
                }
                $(obj).selectRange(0, 0);
            };

        if (typeof (_me.opts.txtMasks) != "undefined") {
            //$.mask.definitions['d'] = '[0-9\.]';
            $.each(_me.opts.txtMasks, function (i, o) {
                //$('input[type="text"][id$="rid_txt_' + o.rid + '"]').mask(o.mask).on({
                //    click: function (event) {
                //        event.preventDefault();
                //        setCursorOnStart(this, event);
                //    },
                //    focusin: function (event) {
                //        setCursorOnStart(this, event);
                //    },
                //    focusout: function (event) {
                //        $(this).removeClass('txtGotFocus');
                //    }
                //});

                //Configure Mask

                if (o.mask) {
                    var _mask = o.mask;

                    //remove the '?' from the mask
                    _mask = _mask.replace(/\?/gi, '');

                    var isOptional = (o.mask).indexOf('?') >= 0,
                        hasDecimal = (o.mask).indexOf('d') >= 0,
                        isDateMask = new RegExp('^(\\d){1,2}\/(\\d){1,2}\/(\\d){2,4}$', 'gi').test(_mask),
                        _placeholder = isDateMask ? '_' : '';

                    if (isOptional) {
                        _mask = '[' + _mask + ']';
                    }

                    //Mask options
                    var _maskOptions = {
                        mask: _mask,
                        greedy: false,
                        placeholder: _placeholder,
                        definitions: {
                            'd': {
                                validator: function (chrs, buffer, pos, strict, opts) {
                                    var cbuffer = buffer.buffer.slice();
                                    cbuffer.splice(pos, 0, chrs);
                                    var bufferStr = cbuffer.join('');
                                    bufferStr = bufferStr.replace(new RegExp(opts.placeholder, 'gi'), '');
                                    return new RegExp("^[0-9]*(\\.)?[0-9]*$").test(bufferStr);
                                },
                                cardinality: 1
                            }
                        },
                        clearIncomplete: false
                    };

                    //Apply the mask to the controls
                    $('input[type="text"][id$="rid_txt_' + o.rid + '"]').inputmask(_maskOptions);
                }

            });
        }
    },

    //check custom logic definitions
    checkCustomLogic: function (callback) {
        var _me = this,
            _mid = $('input[type="hidden"][id$="' + _me.opts.currModule.id + '"]').val();
        
        if (!isNaN(_mid)) {
            //check if we have a custome logic for it...
            var _logic_src = null;
            
            $.each(_me.opts.customLogic, function (i, o) {
                if (o.mid == _mid) {
                    _logic_src = o.src;
                }
            });

            if (_logic_src) {
                //WE HAVE COSTUM LOGIC
                var _c = eval('question.mid' + _mid);
                
                //    _me.applyCustomLogic(_logic_src);
                if (typeof (_c) !== "undefined") {
                    _c.init(callback);
                }
                else {
                    //CRASH; NO CUSTOM LOGIC call Success callback
                    if (callback) {
                        if (typeof (callback.failure) == "function") {
                            callback.failure();
                        }
                    }
                }
            }
            else {
                //NO CUSTOM LOGIC call Success callback
                if (callback) {
                    if (typeof (callback.success) == "function") {
                        callback.success();
                    }
                }
            }
        }
    },

    //helpers
    getQuestionDivByRID: function (rid) {
        var _me = this,
            _d = null,
            _dQuestion = $('div.question-container').filter(function (i, d) {
                return $('[id="' + rid + '"]', $(d)).length > 0;
            })[0];

        if (typeof (_dQuestion) !== "undefined") {
            _d = _dQuestion;
        }

        return _d;
    },

    bindValidations: function () {
        $('input[type="text"], textarea').keyup(function () {
            var bTest1 = false,
                bTest2 = false;

            bTest1 = /<[a-z?!\/]/i.test($(this).val());
            bTest2 = /&#/.test($(this).val());

            if (bTest1 || bTest2) {
                $(this).addClass('question-invalid-input');
            } else {
                $(this).removeClass('question-invalid-input');
            }
        });
    },

    // INITIALIZING FUNCTIONS
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //Settings...
                    _me.opts.isPreloaded = false;
                    if (typeof (_me.opts.responsesData) === "object") {
                        if (_me.opts.responsesData !== "undefined") {
                            if (_me.opts.responsesData.length > 0) {
                                _me.opts.isPreloaded = true;
                            }
                        }
                    }

                    //instrument core logic...
                    _me.applySliders();
                    _me.applyMask();
                    _me.formatHorizontalTbl();
                    _me.applyDatepicker();

                    _me.bindClearAbove();
                    _me.bindSkipPatterns();
                    //_me.checkSkipPatterns();
                    _me.bindValidations();

                    //custom logic & set patient responses...
                    _me.checkCustomLogic({
                        success: function () {
                            //after the instrument is ready (and custom logic is set), set the responses, if any.
                            if (_me.opts.isPreloaded) {
                                _me.setPatientResponses(_me.opts.responsesData);
                            }
                        }
                    });
                                        
                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                        if (typeof (callback.complete) == "function") {
                            callback.complete();
                        }
                    }

                }, 1);
            });
        });
    }
};